<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblVesselTable extends Migration {

	public function up()
	{
		Schema::create('tbl_vessel', function(Blueprint $table) {
			$table->increments('vessel_id', true);
			$table->integer('fleet_id')->unsigned();
			$table->integer('vessel_type_id')->unsigned();
			$table->string('vessel_imo_code', 100);
			$table->string('vessel_name', 100);
			$table->text('vessel_remark')->nullable();
			$table->text('vessel_description')->nullable();
			$table->datetime('vessel_created');
			$table->datetime('vessel_updated');
			$table->datetime('vessel_deleted')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tbl_vessel');
	}
}