<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationTable extends Migration {

	public function up()
	{
		Schema::create('location', function(Blueprint $table) {
			$table->increments('id_location');
			$table->timestamps();
			$table->integer('id_propriete')->unsigned();
			$table->string('type_contart', 100);
			$table->string('duree', 100);
			$table->date('date_debut');
			$table->integer('loyer_initial');
			$table->string('charges', 100);
			$table->string('type_charge', 100);
			$table->boolean('clause');
			$table->string('indice', 100);
			$table->string('description', 1000);
			$table->string('clause_part', 100);
			$table->string('garants', 100);
			$table->boolean('paiement_automatique');
			$table->boolean('echeance_automatique');
			$table->boolean('quittance_automatique');
			$table->boolean('revision_automatique');
		});
	}

	public function down()
	{
		Schema::drop('location');
	}
}