<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProprieteTable extends Migration {

	public function up()
	{
		Schema::create('propriete', function(Blueprint $table) {
			$table->increments('id_propriete');
			$table->timestamps();
			$table->string('nom', 100);
			$table->integer('nbrPieces');
			$table->string('surface', 100);
			$table->string('adresse', 100);
			$table->string('code_postal', 9);
			$table->string('ville', 100);
			$table->string('pays', 100);
			$table->string('description', 1000);
			$table->string('centre', 100);
			$table->integer('nbrLot');
			$table->integer('nbrBatiment');
			$table->integer('nbrEtage');
			$table->integer('id_proprietaire')->unsigned();
			$table->integer('id_type_propriete')->unsigned();
			$table->boolean('eau_chaude');
			$table->boolean('antenne_TV');
		});
	}

	public function down()
	{
		Schema::drop('propriete');
	}
}