<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateToolsCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('tools_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 60);
			$table->text('description');
			$table->string('thumb_url', 255)->nullable();
			$table->integer('menu_position');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tools_categories');
	}
}