<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTokensTable extends Migration {

	public function up()
	{
		Schema::create('tokens', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('token', 40)->unique();
			$table->boolean('forever')->default(false);
			$table->boolean('is_revoked')->default(false);
			$table->datetime('expiry');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tokens');
	}
}