<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateToolsItemsTable extends Migration {

	public function up()
	{
		Schema::create('tools_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('tools_category_id')->unsigned();
			$table->string('name', 60);
			$table->text('description');
			$table->string('item_url', 255);
			$table->string('thumb_url', 255);
			$table->integer('menu_position');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tools_items');
	}
}