<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Providers', function(Blueprint $table) {
			$table->foreign('Category_id')->references('id')->on('Providers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Car_advantage', function(Blueprint $table) {
			$table->foreign('Car_id')->references('id')->on('Car')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Car_image', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('Car')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Car_group', function(Blueprint $table) {
			$table->foreign('Car_id')->references('id')->on('Car')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Branch', function(Blueprint $table) {
			$table->foreign('Provider_id')->references('id')->on('Providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('settlements', function(Blueprint $table) {
			$table->foreign('Order_id')->references('id')->on('Order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Providers', function(Blueprint $table) {
			$table->dropForeign('Providers_Category_id_foreign');
		});
		Schema::table('Car_advantage', function(Blueprint $table) {
			$table->dropForeign('Car_advantage_Car_id_foreign');
		});
		Schema::table('Car_image', function(Blueprint $table) {
			$table->dropForeign('Car_image_car_id_foreign');
		});
		Schema::table('Car_group', function(Blueprint $table) {
			$table->dropForeign('Car_group_Car_id_foreign');
		});
		Schema::table('Branch', function(Blueprint $table) {
			$table->dropForeign('Branch_Provider_id_foreign');
		});
		Schema::table('settlements', function(Blueprint $table) {
			$table->dropForeign('settlements_Order_id_foreign');
		});
	}
}