<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('full_name');
			$table->string('username')->unique();
			$table->string('slug')->unique();
			$table->string('email')->unique();
			$table->datetime('birthday')->nullable();
			$table->string('password', 60);
			$table->string('avatar_url')->nullable();
			$table->rememberToken('remember_token');
			$table->boolean('active')->default(false);
			$table->string('activation_code')->nullable();
			$table->timestamp('deleted_at')->nullable();
			$table->integer('current_team_id')->unsigned()->nullable()->index();
			$table->timestamp('last_accessed_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}