<?php

class Team extends Eloquent {

	protected $table = 'teams';
	public $timestamps = true;
	protected $fillable = array('name', 'photo_url', 'owner_id');
	protected $visible = array('name', 'photo_url', 'owner_id');

	public function users()
	{
		return $this->belongsToMany('User');
	}

	public function owner()
	{
		return $this->belongsTo('Manager');
	}

	public function invitations()
	{
		return $this->hasMany('Invitation');
	}

}