<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('userDisplayName', 255);
			$table->string('userName', 255);
			$table->string('userLastName', 255);
			$table->string('userEmail', 255);
			$table->text('userPasswd');
			$table->date('userBirthDay');
			$table->string('userGender', 2);
			$table->string('userAdress', 255);
			$table->string('userCity', 255);
			$table->string('userCountry', 255);
			$table->string('userFacebookProfile', 255);
			$table->string('userGoogleProfile', 255);
			$table->string('userTwitterProfile', 255);
			$table->string('userWebsiteUrl', 255);
			$table->text('userBiography');
			$table->string('userHomeBackgroundPic', 255);
			$table->string('userProfilePic', 255);
			$table->datetime('userDateOfCreation');
			$table->boolean('userAccountValidation')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}