<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('idCreator')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('recipes', function(Blueprint $table) {
			$table->foreign('idIntolerence')->references('id')->on('intolerences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('idSender')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('idReciever')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_intolerence', function(Blueprint $table) {
			$table->foreign('idIntolerence')->references('id')->on('intolerences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_intolerence', function(Blueprint $table) {
			$table->foreign('idUser')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_role', function(Blueprint $table) {
			$table->foreign('idUser')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_role', function(Blueprint $table) {
			$table->foreign('idRole')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event_members', function(Blueprint $table) {
			$table->foreign('idEvent')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event_members', function(Blueprint $table) {
			$table->foreign('idMember')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event_recipes', function(Blueprint $table) {
			$table->foreign('idEvent')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event_recipes', function(Blueprint $table) {
			$table->foreign('idRecipe')->references('id')->on('recipes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_idCreator_foreign');
		});
		Schema::table('recipes', function(Blueprint $table) {
			$table->dropForeign('recipes_idIntolerence_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_idSender_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_idReciever_foreign');
		});
		Schema::table('user_intolerence', function(Blueprint $table) {
			$table->dropForeign('user_intolerence_idIntolerence_foreign');
		});
		Schema::table('user_intolerence', function(Blueprint $table) {
			$table->dropForeign('user_intolerence_idUser_foreign');
		});
		Schema::table('user_role', function(Blueprint $table) {
			$table->dropForeign('user_role_idUser_foreign');
		});
		Schema::table('user_role', function(Blueprint $table) {
			$table->dropForeign('user_role_idRole_foreign');
		});
		Schema::table('event_members', function(Blueprint $table) {
			$table->dropForeign('event_members_idEvent_foreign');
		});
		Schema::table('event_members', function(Blueprint $table) {
			$table->dropForeign('event_members_idMember_foreign');
		});
		Schema::table('event_recipes', function(Blueprint $table) {
			$table->dropForeign('event_recipes_idEvent_foreign');
		});
		Schema::table('event_recipes', function(Blueprint $table) {
			$table->dropForeign('event_recipes_idRecipe_foreign');
		});
	}
}