<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('idCreator')->unsigned();
			$table->datetime('eventDateTime');
			$table->text('EventAdress');
			$table->string('eventCity', 100);
			$table->string('eventCountry', 100)->default('fr');
			$table->boolean('eventPermission')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}