<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNetworkTable extends Migration {

	public function up()
	{
		Schema::create('network', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('sender_id')->unsigned();
			$table->bigInteger('receiver_id')->unsigned();
			$table->datetime('requested_at');
			$table->datetime('accepted_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('network');
	}
}