<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponZonesTable extends Migration {

	public function up()
	{
		Schema::create('coupon_zones', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 100);
			$table->text('description')->nullable();
			$table->enum('status', array('pending', 'progress', 'ended'))->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('coupon_zones');
	}
}