<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertiesTable extends Migration {

	public function up()
	{
		Schema::create('properties', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('protfolio_id');
			$table->integer('owner_id');
			$table->text('address');
			$table->date('received_date');
			$table->string('account_number', 50);
			$table->string('phone', 50);
			$table->string('receipt_number');
			$table->integer('property_no');
			$table->string('latitude', 25);
			$table->string('longitude', 25);
			$table->string('estimated_value', 255);
			$table->string('property_value', 255);
			$table->date('built_date');
			$table->enum('uses', array('commercial', 'Investment', 'real_estate_investment', 'residential', 'industrial', 'stores', 'agricultural'));
			$table->timestamps();
			$table->softDeletes();
			$table->string('location', 255);
			$table->integer('cladding_type');
			$table->integer('sanitary_type');
			$table->string('Leaseability_notes', 255);
			$table->integer('finishing_type');
			$table->integer('space');
			$table->date('power_delivery_date');
			$table->date('Expected_withdrawal_date');
			$table->string('Leaseability', 255);
			$table->date('Leaseability_date');
			$table->integer('gaurd_id');
		});
	}

	public function down()
	{
		Schema::drop('properties');
	}
}