<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('military_number');
			$table->string('job_number');
			$table->string('degree');
			$table->string('image')->nullable();
			$table->date('date_expired');
			$table->string('email');
			$table->string('name_person');
			$table->string('contact_number');
			$table->integer('archives_number');
			$table->text('notes')->nullable();
			$table->string('password');
			$table->integer('category_id')->unsigned();
			$table->integer('properties_users_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}