<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShippingCity extends Model 
{

    protected $table = 'shipping_city';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('city_id');

    public function city()
    {
        return $this->belongsTo('City', 'city');
    }

}