<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReturnOrderTable extends Migration {

	public function up()
	{
		Schema::create('return_order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_id')->nullable();
			$table->integer('order_product_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->integer('reason_id')->nullable();
			$table->text('note')->nullable();
			$table->text('reply')->nullable();
			$table->enum('status', array('rejected', 'accepted', 'requested'))->nullable();
			$table->text('reject_reason')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('return_order');
	}
}