<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ReturnOrder extends Model 
{

    protected $table = 'return_order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'order_product_id', 'user_id', 'reason_id', 'note', 'reply', 'status', 'reject_reason');

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function reason()
    {
        return $this->belongsTo('ReturnReason', 'reason_id');
    }

    public function order_product()
    {
        return $this->belongsTo('OrderProduct', 'order_product_id');
    }

}