<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('city_id')->nullable();
			$table->integer('address_id')->nullable();
			$table->double('total')->nullable();
			$table->double('price')->nullable();
			$table->double('revenue')->nullable();
			$table->double('tax')->nullable();
			$table->double('shipping_price')->nullable();
			$table->double('discount')->nullable();
			$table->enum('status', array('completed', 'inprogress', 'shipping', 'cancelled'))->nullable();
			$table->enum('shipping_method', array('local', 'aramex'))->nullable();
			$table->datetime('delivery_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}