<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderProduct extends Eloquent {

	protected $table = 'order_product';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'product_id', 'quantity', 'total', 'price', 'revenue', 'tax');

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

	public function product()
	{
		return $this->belongsTo('Product', 'product_id');
	}

}