<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ReturnOrder extends Eloquent {

	protected $table = 'return_order';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'order_product_id', 'user_id', 'reason_id', 'note', 'reply', 'status', 'reject_reason');

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function reason()
	{
		return $this->belongsTo('ReturnReason', 'reason_id');
	}

	public function order_product()
	{
		return $this->belongsTo('OrderProduct', 'order_product_id');
	}

}