<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'description_en', 'description_ar', 'parent_id');

	public function products()
	{
		return $this->hasMany('Product', 'category_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'parent_id');
	}

	public function categories()
	{
		return $this->hasMany('Category', 'parent_id');
	}

}