<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'order';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'city_id', 'address_id', 'total', 'price', 'revenue', 'tax', 'shipping_price', 'discount', 'status', 'shipping_method', 'delivery_date');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

	public function address()
	{
		return $this->belongsTo('Address', 'address_id');
	}

	public function products()
	{
		return $this->hasMany('OrderProduct', 'order_id');
	}

}