<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectTable extends Migration {

	public function up()
	{
		Schema::create('project', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('city')->nullable();
			$table->string('date')->nullable();
			$table->string('main_contractor')->nullable();
			$table->string('owner')->nullable();
			$table->string('contractor')->nullable();
			$table->text('space_of_work')->nullable();
			$table->text('responsibilities')->nullable();
			$table->integer('sorter')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('project');
	}
}