<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_kota')->references('id')->on('citys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_point')->references('id')->on('points')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_level')->references('id')->on('levels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->foreign('id_province')->references('id')->on('provinces')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('citys', function(Blueprint $table) {
			$table->foreign('id_district')->references('id')->on('districts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agents', function(Blueprint $table) {
			$table->foreign('id_kota')->references('id')->on('citys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agents', function(Blueprint $table) {
			$table->foreign('id_point')->references('id')->on('points')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agents', function(Blueprint $table) {
			$table->foreign('id_level')->references('id')->on('levels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('id_agen')->references('id')->on('agents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('id_kota')->references('id')->on('citys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('id_level')->references('id')->on('levels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_kota_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_point_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_level_foreign');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->dropForeign('districts_id_province_foreign');
		});
		Schema::table('citys', function(Blueprint $table) {
			$table->dropForeign('citys_id_district_foreign');
		});
		Schema::table('agents', function(Blueprint $table) {
			$table->dropForeign('agents_id_kota_foreign');
		});
		Schema::table('agents', function(Blueprint $table) {
			$table->dropForeign('agents_id_point_foreign');
		});
		Schema::table('agents', function(Blueprint $table) {
			$table->dropForeign('agents_id_level_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_id_user_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_id_agen_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_id_kota_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_id_level_foreign');
		});
	}
}