<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Request extends Model 
{

    protected $table = 'requests';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function service()
    {
        return $this->belongsTo('Service');
    }

    public function request_type()
    {
        return $this->hasOne('Request_Types');
    }

    public function payment()
    {
        return $this->belongsTo('Payment');
    }

}