<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('discription')->nullable();
			$table->decimal('price', 10,2);
			$table->enum('category', array('CRM', 'SMS', 'Hosting', 'Support', 'SMS_Sender'));
			$table->enum('status', array('active', 'inactive', 'on-hold'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}