<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user_services()
	{
		return $this->hasMany('User_Service');
	}

	public function payments()
	{
		return $this->hasMany('Payment');
	}

	public function requests()
	{
		return $this->hasMany('Request');
	}

	public function invoices()
	{
		return $this->hasMany('Invoices');
	}

	public function role()
	{
		return $this->belongsTo('Roles');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

}