<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_services', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('request_types_id')->references('id')->on('request_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_sms_balances', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_sms_balances', function(Blueprint $table) {
			$table->foreign('sms_package_id')->references('id')->on('sms_packages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_parent_id_foreign');
		});
		Schema::table('user_services', function(Blueprint $table) {
			$table->dropForeign('user_services_user_id_foreign');
		});
		Schema::table('user_services', function(Blueprint $table) {
			$table->dropForeign('user_services_service_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_user_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_user_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_service_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_request_types_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_payment_id_foreign');
		});
		Schema::table('user_sms_balances', function(Blueprint $table) {
			$table->dropForeign('user_sms_balances_user_id_foreign');
		});
		Schema::table('user_sms_balances', function(Blueprint $table) {
			$table->dropForeign('user_sms_balances_sms_package_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_user_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_payment_id_foreign');
		});
	}
}