<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Request extends Eloquent {

	protected $table = 'requests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function service()
	{
		return $this->belongsTo('Service');
	}

	public function request_type()
	{
		return $this->hasOne('Request_Types');
	}

	public function payment()
	{
		return $this->belongsTo('Payment');
	}

}