<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLoanerVehicleParkingDetailsTable extends Migration {

	public function up()
	{
		Schema::create('loaner_vehicle_parking_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('loaner_vehicle_id')->unsigned();
			$table->smallInteger('parking_number')->index()->default('0');
			$table->string('parking_location');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('parked_by')->unsigned();
			$table->datetime('parking_time');
		});
	}

	public function down()
	{
		Schema::drop('loaner_vehicle_parking_details');
	}
}