<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransmissionTypeTable extends Migration {

	public function up()
	{
		Schema::create('transmission_type', function(Blueprint $table) {
			$table->increments('id');
			$table->string('transmission_name', 255)->index();
			$table->mediumText('transmission_desc')->nullable()->index();
			$table->integer('dealer_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('transmission_type');
	}
}