<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersBreakTimingsTable extends Migration {

	public function up()
	{
		Schema::create('users_break_timings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->time('break_timing_1')->index();
			$table->time('break_timing_2')->index();
			$table->time('break_timing_3');
			$table->time('break_timing_4');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('created_by')->unsigned();
			$table->datetime('created_date');
			$table->integer('modified_by')->unsigned();
			$table->datetime('modified_date');
		});
	}

	public function down()
	{
		Schema::drop('users_break_timings');
	}
}