<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCityTable extends Migration {

	public function up()
	{
		Schema::create('city', function(Blueprint $table) {
			$table->increments('id');
			$table->string('city_name', 100);
			$table->integer('state_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->integer('dealer_id')->unsigned()->index()->default('0');
			$table->timestamps();
			$table->tinyInteger('status');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('city');
	}
}