<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGasPricesTable extends Migration {

	public function up()
	{
		Schema::create('gas_prices', function(Blueprint $table) {
			$table->increments('id');
			$table->string('gas_type', 255)->index()->default('0');
			$table->float('gas_price')->index()->default('0.0');
			$table->string('gas_unit', 255)->nullable()->index();
			$table->integer('dealer_id')->unsigned()->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('gas_prices');
	}
}