<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('gas_prices', function(Blueprint $table) {
			$table->foreign('dealer_id')->references('id')->on('user_roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('state')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->foreign('dealer_id')->references('id')->on('user_roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('state', function(Blueprint $table) {
			$table->foreign('dealer_id')->references('id')->on('user_roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('country', function(Blueprint $table) {
			$table->foreign('dealer_id')->references('id')->on('user_roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_address', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_address', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('city')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_address', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('state')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_address', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('contact_type', function(Blueprint $table) {
			$table->foreign('dealer_id')->references('id')->on('user_roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_contact_details', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_contact_details', function(Blueprint $table) {
			$table->foreign('contact_type_id')->references('id')->on('contact_type')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_license_info', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_license_info', function(Blueprint $table) {
			$table->foreign('license_issuing_state')->references('id')->on('state')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_cc_info', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('insurance_companies', function(Blueprint $table) {
			$table->foreign('dealer_id')->references('id')->on('user_roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vehicle_insurance_info', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vehicle_insurance_info', function(Blueprint $table) {
			$table->foreign('insurance_company_id')->references('id')->on('insurance_companies')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vehicle_insurance_info', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('state')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('transmission_type', function(Blueprint $table) {
			$table->foreign('dealer_id')->references('id')->on('user_roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vehicle_body_type', function(Blueprint $table) {
			$table->foreign('dealer_id')->references('id')->on('user_roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('user_roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('modified_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_contact_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_contact_details', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_contact_details', function(Blueprint $table) {
			$table->foreign('contact_type_id')->references('id')->on('contact_type')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_contact_details', function(Blueprint $table) {
			$table->foreign('modified_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_vehicle_info', function(Blueprint $table) {
			$table->foreign('body_type')->references('id')->on('vehicle_body_type')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('grounded_reason', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('grounded_reason', function(Blueprint $table) {
			$table->foreign('dealer_id')->references('id')->on('user_roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vehicle_features', function(Blueprint $table) {
			$table->foreign('dealer_id')->references('id')->on('user_roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_threshold_criteria', function(Blueprint $table) {
			$table->foreign('loaner_vehicle_id')->references('id')->on('loaner_vehicle_info')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users_break_timings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users_break_timings', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users_break_timings', function(Blueprint $table) {
			$table->foreign('modified_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users_holiday_log', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users_holiday_log', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users_holiday_log', function(Blueprint $table) {
			$table->foreign('modified_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users_holiday_log', function(Blueprint $table) {
			$table->foreign('approved_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_vehicle_inventory', function(Blueprint $table) {
			$table->foreign('loaner_vehicle_id')->references('id')->on('loaner_vehicle_info')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_vehicle_inventory', function(Blueprint $table) {
			$table->foreign('transmission_type_id')->references('id')->on('transmission_type')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_vehicle_inventory', function(Blueprint $table) {
			$table->foreign('current_status')->references('id')->on('loaner_vehicle_status')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_vehicle_inventory', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_vehicle_inventory', function(Blueprint $table) {
			$table->foreign('modified_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_vehicle_status', function(Blueprint $table) {
			$table->foreign('dealer_id')->references('id')->on('user_roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_vehicle_inventory_log', function(Blueprint $table) {
			$table->foreign('loaner_vehicle_inventory_id')->references('id')->on('loaner_vehicle_inventory')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_vehicle_parking_details', function(Blueprint $table) {
			$table->foreign('loaner_vehicle_id')->references('id')->on('loaner_vehicle_inventory')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_vehicle_parking_details', function(Blueprint $table) {
			$table->foreign('parked_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_vehicle_parking_details_log', function(Blueprint $table) {
			$table->foreign('loaner_vehicle_parking_details_id')->references('id')->on('loaner_vehicle_parking_details')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_agreement', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_agreement', function(Blueprint $table) {
			$table->foreign('loaner_vehicle_id')->references('id')->on('loaner_vehicle_inventory')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_agreement', function(Blueprint $table) {
			$table->foreign('checkout_advisor_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('loaner_agreement', function(Blueprint $table) {
			$table->foreign('checkin_advisor_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('gas_prices', function(Blueprint $table) {
			$table->dropForeign('gas_prices_dealer_id_foreign');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->dropForeign('city_state_id_foreign');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->dropForeign('city_country_id_foreign');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->dropForeign('city_dealer_id_foreign');
		});
		Schema::table('state', function(Blueprint $table) {
			$table->dropForeign('state_dealer_id_foreign');
		});
		Schema::table('country', function(Blueprint $table) {
			$table->dropForeign('country_dealer_id_foreign');
		});
		Schema::table('customer_address', function(Blueprint $table) {
			$table->dropForeign('customer_address_customer_id_foreign');
		});
		Schema::table('customer_address', function(Blueprint $table) {
			$table->dropForeign('customer_address_city_id_foreign');
		});
		Schema::table('customer_address', function(Blueprint $table) {
			$table->dropForeign('customer_address_state_id_foreign');
		});
		Schema::table('customer_address', function(Blueprint $table) {
			$table->dropForeign('customer_address_country_id_foreign');
		});
		Schema::table('contact_type', function(Blueprint $table) {
			$table->dropForeign('contact_type_dealer_id_foreign');
		});
		Schema::table('customer_contact_details', function(Blueprint $table) {
			$table->dropForeign('customer_contact_details_customer_id_foreign');
		});
		Schema::table('customer_contact_details', function(Blueprint $table) {
			$table->dropForeign('customer_contact_details_contact_type_id_foreign');
		});
		Schema::table('customer_license_info', function(Blueprint $table) {
			$table->dropForeign('customer_license_info_customer_id_foreign');
		});
		Schema::table('customer_license_info', function(Blueprint $table) {
			$table->dropForeign('customer_license_info_license_issuing_state_foreign');
		});
		Schema::table('customer_cc_info', function(Blueprint $table) {
			$table->dropForeign('customer_cc_info_customer_id_foreign');
		});
		Schema::table('insurance_companies', function(Blueprint $table) {
			$table->dropForeign('insurance_companies_dealer_id_foreign');
		});
		Schema::table('vehicle_insurance_info', function(Blueprint $table) {
			$table->dropForeign('vehicle_insurance_info_customer_id_foreign');
		});
		Schema::table('vehicle_insurance_info', function(Blueprint $table) {
			$table->dropForeign('vehicle_insurance_info_insurance_company_id_foreign');
		});
		Schema::table('vehicle_insurance_info', function(Blueprint $table) {
			$table->dropForeign('vehicle_insurance_info_state_id_foreign');
		});
		Schema::table('transmission_type', function(Blueprint $table) {
			$table->dropForeign('transmission_type_dealer_id_foreign');
		});
		Schema::table('vehicle_body_type', function(Blueprint $table) {
			$table->dropForeign('vehicle_body_type_dealer_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_created_by_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_modified_by_foreign');
		});
		Schema::table('user_contact_details', function(Blueprint $table) {
			$table->dropForeign('user_contact_details_user_id_foreign');
		});
		Schema::table('user_contact_details', function(Blueprint $table) {
			$table->dropForeign('user_contact_details_created_by_foreign');
		});
		Schema::table('user_contact_details', function(Blueprint $table) {
			$table->dropForeign('user_contact_details_contact_type_id_foreign');
		});
		Schema::table('user_contact_details', function(Blueprint $table) {
			$table->dropForeign('user_contact_details_modified_by_foreign');
		});
		Schema::table('loaner_vehicle_info', function(Blueprint $table) {
			$table->dropForeign('loaner_vehicle_info_body_type_foreign');
		});
		Schema::table('grounded_reason', function(Blueprint $table) {
			$table->dropForeign('grounded_reason_created_by_foreign');
		});
		Schema::table('grounded_reason', function(Blueprint $table) {
			$table->dropForeign('grounded_reason_dealer_id_foreign');
		});
		Schema::table('vehicle_features', function(Blueprint $table) {
			$table->dropForeign('vehicle_features_dealer_id_foreign');
		});
		Schema::table('loaner_threshold_criteria', function(Blueprint $table) {
			$table->dropForeign('loaner_threshold_criteria_loaner_vehicle_id_foreign');
		});
		Schema::table('users_break_timings', function(Blueprint $table) {
			$table->dropForeign('users_break_timings_user_id_foreign');
		});
		Schema::table('users_break_timings', function(Blueprint $table) {
			$table->dropForeign('users_break_timings_created_by_foreign');
		});
		Schema::table('users_break_timings', function(Blueprint $table) {
			$table->dropForeign('users_break_timings_modified_by_foreign');
		});
		Schema::table('users_holiday_log', function(Blueprint $table) {
			$table->dropForeign('users_holiday_log_user_id_foreign');
		});
		Schema::table('users_holiday_log', function(Blueprint $table) {
			$table->dropForeign('users_holiday_log_created_by_foreign');
		});
		Schema::table('users_holiday_log', function(Blueprint $table) {
			$table->dropForeign('users_holiday_log_modified_by_foreign');
		});
		Schema::table('users_holiday_log', function(Blueprint $table) {
			$table->dropForeign('users_holiday_log_approved_by_foreign');
		});
		Schema::table('loaner_vehicle_inventory', function(Blueprint $table) {
			$table->dropForeign('loaner_vehicle_inventory_loaner_vehicle_id_foreign');
		});
		Schema::table('loaner_vehicle_inventory', function(Blueprint $table) {
			$table->dropForeign('loaner_vehicle_inventory_transmission_type_id_foreign');
		});
		Schema::table('loaner_vehicle_inventory', function(Blueprint $table) {
			$table->dropForeign('loaner_vehicle_inventory_current_status_foreign');
		});
		Schema::table('loaner_vehicle_inventory', function(Blueprint $table) {
			$table->dropForeign('loaner_vehicle_inventory_created_by_foreign');
		});
		Schema::table('loaner_vehicle_inventory', function(Blueprint $table) {
			$table->dropForeign('loaner_vehicle_inventory_modified_by_foreign');
		});
		Schema::table('loaner_vehicle_status', function(Blueprint $table) {
			$table->dropForeign('loaner_vehicle_status_dealer_id_foreign');
		});
		Schema::table('loaner_vehicle_inventory_log', function(Blueprint $table) {
			$table->dropForeign('loaner_vehicle_inventory_log_loaner_vehicle_inventory_id_foreign');
		});
		Schema::table('loaner_vehicle_parking_details', function(Blueprint $table) {
			$table->dropForeign('loaner_vehicle_parking_details_loaner_vehicle_id_foreign');
		});
		Schema::table('loaner_vehicle_parking_details', function(Blueprint $table) {
			$table->dropForeign('loaner_vehicle_parking_details_parked_by_foreign');
		});
		Schema::table('loaner_vehicle_parking_details_log', function(Blueprint $table) {
			$table->dropForeign('loaner_vehicle_parking_details_log_loaner_vehicle_parking_details_id_foreign');
		});
		Schema::table('loaner_agreement', function(Blueprint $table) {
			$table->dropForeign('loaner_agreement_customer_id_foreign');
		});
		Schema::table('loaner_agreement', function(Blueprint $table) {
			$table->dropForeign('loaner_agreement_loaner_vehicle_id_foreign');
		});
		Schema::table('loaner_agreement', function(Blueprint $table) {
			$table->dropForeign('loaner_agreement_checkout_advisor_id_foreign');
		});
		Schema::table('loaner_agreement', function(Blueprint $table) {
			$table->dropForeign('loaner_agreement_checkin_advisor_id_foreign');
		});
	}
}