<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGroundedReasonTable extends Migration {

	public function up()
	{
		Schema::create('grounded_reason', function(Blueprint $table) {
			$table->increments('id');
			$table->string('reason', 255)->index();
			$table->integer('created_by')->unsigned();
			$table->datetime('created_date');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('dealer_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('grounded_reason');
	}
}