<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLoanerAgreementTable extends Migration {

	public function up()
	{
		Schema::create('loaner_agreement', function(Blueprint $table) {
			$table->increments('id');
			$table->string('agreement_id', 255)->unique();
			$table->integer('customer_id')->unsigned();
			$table->integer('loaner_vehicle_id')->unsigned();
			$table->datetime('checkout_date')->index();
			$table->integer('checkout_advisor_id')->unsigned();
			$table->datetime('checkin_date')->index();
			$table->integer('checkin_advisor_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('loaner_agreement');
	}
}