<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLoanerVehicleInfoTable extends Migration {

	public function up()
	{
		Schema::create('loaner_vehicle_info', function(Blueprint $table) {
			$table->increments('id');
			$table->string('car_name', 255)->index();
			$table->string('car_series', 255)->index();
			$table->char('make_year', 4)->index();
			$table->integer('body_type')->unsigned();
			$table->string('license_number', 255)->index();
			$table->string('transmission_type', 255)->index();
			$table->text('car_description')->index();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('loaner_vehicle_info');
	}
}