<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerContactDetailsTable extends Migration {

	public function up()
	{
		Schema::create('customer_contact_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned();
			$table->integer('contact_type_id')->unsigned();
			$table->string('contact_value', 255)->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customer_contact_details');
	}
}