<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersHolidayLogTable extends Migration {

	public function up()
	{
		Schema::create('users_holiday_log', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->datetime('start_date')->index();
			$table->datetime('end_date')->index();
			$table->text('user_comments');
			$table->integer('created_by')->unsigned();
			$table->datetime('created_date');
			$table->integer('modified_by')->unsigned();
			$table->integer('approved_by')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users_holiday_log');
	}
}