<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 255)->unique();
			$table->string('firstname', 255);
			$table->string('lastname', 255);
			$table->string('password');
			$table->string('email', 255)->unique();
			$table->string('companyname');
			$table->boolean('activated')->default(false);
			$table->string('remember_token', 100);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}