<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePageTable extends Migration {

	public function up()
	{
		Schema::create('page', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('title', 255);
			$table->text('content');
			$table->string('meta_description', 255)->nullable();
			$table->string('meta_keywords', 255)->nullable();
			$table->string('slug', 255);
			$table->integer('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('page');
	}
}