<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceTable extends Migration {

	public function up()
	{
		Schema::create('invoice', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->date('date_start');
			$table->decimal('plan_price');
			$table->string('plan_name');
			$table->string('user_name');
			$table->string('user_address');
			$table->string('user_company')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoice');
	}
}