<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventInvitationsTable extends Migration {

	public function up()
	{
		Schema::create('event_invitations', function(Blueprint $table) {
			$table->string('uuid')->primary();
			$table->integer('profile_type_id')->nullable();
			$table->string('event_uuid', 128);
			$table->string('attendee_uuid', 128)->nullable();
			$table->string('status', 28)->nullable();
			$table->string('phone_number', 28)->nullable();
			$table->string('email', 64)->nullable();
			$table->string('first_name', 128)->nullable();
			$table->string('last_name', 64)->nullable();
			$table->string('method')->nullable();
			$table->datetime('sent_at')->nullable();
			$table->json('data');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('event_invitations');
	}
}