<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->string('uuid');
			$table->integer('profile_id');
			$table->integer('parent_event_uuid')->nullable();
			$table->integer('type_id')->unsigned()->default('0');
			$table->integer('location_id')->default('0');
			$table->string('code', 11);
			$table->string('name', 256);
			$table->string('timezone');
			$table->timestamp('starts_at');
			$table->timestamp('ends_at');
			$table->timestamp('open_at')->nullable();
			$table->timestamp('close_at')->nullable();
			$table->json('data');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}