<?php

class Attendee extends Eloquent {

	protected $table = 'attendees';
	public $timestamps = true;
	protected $fillable = array('uuid', 'event_uuid', 'status', 'data');

	public function event()
	{
		return $this->belongsTo('Events');
	}

	public function groups()
	{
		return $this->hasManyThrough('Groups', 'AttendeeGroups', 'attendee_uuid', 'group_uuid');
	}

}