<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormRequestEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('form_request_employees', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->softDeletes();
			$table->string('code', 3)->unique();
			$table->integer('division_id');
			$table->integer('position_id');
			$table->date('date_join_request');
			$table->integer('client_id');
			$table->string('type_request', 30);
			$table->string('location', 191);
			$table->string('location_info', 191);
			$table->integer('reason_id');
			$table->integer('project_categorys_id');
			$table->string('status', 191);
			$table->text('status_notes');
			$table->text('notes');
			$table->timestamp('approval_manager_at');
			$table->timestamp('approval_hr_at');
		});
	}

	public function down()
	{
		Schema::drop('form_request_employees');
	}
}