<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Department extends Eloquent {

	protected $table = 'departments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function employees()
	{
		return $this->belongsToMany('App\Model\Employee');
	}

	public function posisitions()
	{
		return $this->hasMany('App\Model\Posititon');
	}

}